#ifndef __CAreaBox__
#define __CAreaBox__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CAreaBox CAreaBox.hpp
			 * @brief Draws a box round an area.
			 *
			 * @date 17/07/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CAreaBox.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CAreaBox : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param area The area of this control relative to the root controls top left
				 */
				CAreaBox(IControlRoot *root, const CRect &area);

				/**
				 * Destruction
				 */
				virtual ~CAreaBox();

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================
			};
		}
	}
}
#endif	// End of CAreaBox.hpp